/*
 * MODULE: RAM Size Check
 * ID: ram-size-check
 * DESCRIPTION: Exits if RAM is below threshold (VM detection)
 * CATEGORY: Hardware Detection
 * SUPPORTED_EXECUTION_TYPES: native-executable,native-executable-aot
 *
 * PARAMETERS:
 * @MinRamGB|int|4|1|128|required|Minimum RAM in GB required
 */

// USINGS
using System;

// CODE
var totalRamGB = GC.GetGCMemoryInfo().TotalAvailableMemoryBytes / (1024.0 * 1024.0 * 1024.0);
Console.WriteLine($"[RAM Check] Detected {totalRamGB:F2} GB RAM");

if (totalRamGB < @MinRamGB)
{
    Console.WriteLine($"[RAM Check] FAILED - Has {totalRamGB:F2} GB RAM, required minimum: {@MinRamGB} GB. Exiting due to insufficient memory.");
    Environment.Exit(1);
}
else
{
    Console.WriteLine($"[RAM Check] PASSED - Has {totalRamGB:F2} GB RAM, meets minimum requirement of {@MinRamGB} GB.");
}
