/*
 * MODULE: CPU Core Check
 * ID: cpu-core-check
 * DESCRIPTION: Exits if CPU core count is below threshold (VM detection)
 * CATEGORY: Hardware Detection
 * SUPPORTED_EXECUTION_TYPES: native-executable,native-executable-aot
 *
 * PARAMETERS:
 * @MinCores|int|2|4|64|required|Minimum CPU cores required
 */

// USINGS
using System;

// CODE
var cpuCount = Environment.ProcessorCount;
Console.WriteLine($"[CPU Check] Detected {cpuCount} CPU core(s)");

if (cpuCount < @MinCores)
{
    Console.WriteLine($"[CPU Check] FAILED - Has {cpuCount} cores, required minimum: {@MinCores} cores. Exiting due to insufficient CPU cores.");
    Environment.Exit(1);
}
else
{
    Console.WriteLine($"[CPU Check] PASSED - Has {cpuCount} cores, meets minimum requirement of {@MinCores} cores.");
}
