/*
 * MODULE: Ransomware Demo (Benign)
 * ID: ransomware-demo
 * DESCRIPTION: Benign ransomware simulation for EDR testing - encrypts test files in Desktop\not_my_files folder only
 * CATEGORY: Malware Simulation - TESTING ONLY
 * SUPPORTED_EXECUTION_TYPES: native-executable,native-executable-aot
 *
 * PARAMETERS:
 * @RansomMessage|string|FILES ENCRYPTED - SECURITY TEST|||required|Message to display to user
 * @EncryptionKey|string|TEST-KEY-12345-ABCDE|||required|Encryption key (will be shown in message for decryption)
 * @FileCount|int|50||placeholder=50|Number of dummy files to generate if folder doesn't exist
 * @ShowDecryptOption|bool|true|||Show decrypt button in message box
 * @FileExtension|string|.enc|||Extension to add to encrypted files
 *
 * WARNING: FOR AUTHORIZED SECURITY PRODUCT TESTING ONLY
 * This module demonstrates ransomware behavior in a completely benign way by only targeting a test folder.
 */

// USINGS
using System;
using System.IO;
using System.Linq;
using System.Security.Cryptography;
using System.Text;
using System.Runtime.InteropServices;

// CODE
Console.WriteLine("[!] BENIGN RANSOMWARE SIMULATION");
Console.WriteLine("[!] FOR AUTHORIZED SECURITY TESTING ONLY");
Console.WriteLine("");

var ransomMessage = @RansomMessage;
var encryptionKey = @EncryptionKey;
var fileCount = @FileCount;
var showDecryptOption = @ShowDecryptOption;
var fileExtension = @FileExtension;

// Get Desktop path and target folder
var desktopPath = Environment.GetFolderPath(Environment.SpecialFolder.Desktop);
var targetFolder = Path.Combine(desktopPath, "not_my_files");

Console.WriteLine($"[*] Target folder: {targetFolder}");

// Create folder and generate dummy files if it doesn't exist
if (!Directory.Exists(targetFolder))
{
    Console.WriteLine("[*] Target folder not found, creating with dummy files...");
    Directory.CreateDirectory(targetFolder);

    GenerateDummyFiles(targetFolder, fileCount);
    Console.WriteLine($"[+] Generated {fileCount} dummy files");
}
else
{
    Console.WriteLine("[*] Target folder exists");
}

// Get all files in the target folder (not already encrypted)
var filesToEncrypt = Directory.GetFiles(targetFolder)
    .Where(f => !f.EndsWith(fileExtension))
    .ToArray();

Console.WriteLine($"[*] Found {filesToEncrypt.Length} files to encrypt");

if (filesToEncrypt.Length == 0)
{
    Console.WriteLine("[-] No files to encrypt");
    return;
}

// Encrypt files
int encryptedCount = 0;
foreach (var file in filesToEncrypt)
{
    try
    {
        EncryptFile(file, encryptionKey, fileExtension);
        encryptedCount++;
    }
    catch (Exception ex)
    {
        Console.WriteLine($"[-] Failed to encrypt {Path.GetFileName(file)}: {ex.Message}");
    }
}

Console.WriteLine($"[+] Encrypted {encryptedCount} files");

// Create ransom note
var ransomNotePath = Path.Combine(targetFolder, "DECRYPT_INSTRUCTIONS.txt");
var fullMessage = $@"{ransomMessage}

===========================================
DECRYPTION INFORMATION
===========================================

Your files have been encrypted for security testing purposes.

Files encrypted: {encryptedCount}
Encryption key: {encryptionKey}
Target folder: {targetFolder}

This is a BENIGN security test. Your actual files are safe.
Only the test folder 'not_my_files' on your Desktop was affected.

To decrypt:
1. Use the decryption key shown above
2. Click 'Yes' on the message box (if shown)
3. Or run this program again with decrypt option

===========================================
Generated: {DateTime.Now}
===========================================
";

File.WriteAllText(ransomNotePath, fullMessage);
Console.WriteLine($"[+] Created ransom note: {ransomNotePath}");

// Show message box if requested
if (showDecryptOption)
{
    var messageBoxText = $@"{ransomMessage}

Files encrypted: {encryptedCount}
Decryption key: {encryptionKey}

Decrypt files now?";

    var result = NativeMethods.MessageBox(IntPtr.Zero, messageBoxText,
        "Ransomware Simulation (BENIGN TEST)",
        NativeMethods.MB_YESNO | NativeMethods.MB_ICONWARNING | NativeMethods.MB_SYSTEMMODAL);

    if (result == NativeMethods.IDYES)
    {
        Console.WriteLine("\n[*] User chose to decrypt files...");
        DecryptAllFiles(targetFolder, encryptionKey, fileExtension);
    }
    else
    {
        Console.WriteLine("\n[*] User chose not to decrypt. Files remain encrypted for testing.");
        Console.WriteLine($"[*] To decrypt later, use key: {encryptionKey}");
    }
}
else
{
    Console.WriteLine($"\n[*] Decryption key: {encryptionKey}");
    Console.WriteLine($"[*] Files remain encrypted for testing");
}

Console.WriteLine("\n[*] Ransomware simulation complete");

// Helper functions
void GenerateDummyFiles(string folder, int count)
{
    var random = new Random();

    // Generate various file types
    var fileTypes = new (string, Action<string, Random>)[]
    {
        (".txt", GenerateTextFile),
        (".doc", GenerateDocFile),
        (".jpg", GenerateImageFile),
        (".pdf", GeneratePdfFile),
        (".xlsx", GenerateExcelFile)
    };

    for (int i = 0; i < count; i++)
    {
        var (ext, generator) = fileTypes[i % fileTypes.Length];
        var fileName = $"document_{i:D4}{ext}";
        var filePath = Path.Combine(folder, fileName);

        generator(filePath, random);
    }
}

void GenerateTextFile(string path, Random random)
{
    var content = new StringBuilder();
    content.AppendLine($"Test Document {Path.GetFileNameWithoutExtension(path)}");
    content.AppendLine($"Generated: {DateTime.Now}");
    content.AppendLine();
    content.AppendLine("This is a dummy file created for ransomware simulation testing.");

    for (int i = 0; i < random.Next(5, 20); i++)
    {
        content.AppendLine($"Line {i + 1}: Lorem ipsum dolor sit amet, consectetur adipiscing elit.");
    }

    File.WriteAllText(path, content.ToString());
}

void GenerateDocFile(string path, Random random)
{
    // Simple fake DOC file (just text with .doc extension for demo)
    var content = $"FAKE DOC FILE - Created {DateTime.Now}\n";
    content += new string('A', random.Next(500, 2000));
    File.WriteAllText(path, content);
}

void GenerateImageFile(string path, Random random)
{
    // Tiny fake JPG header (will look like corrupted image, good for testing)
    var fakeJpg = new byte[] { 0xFF, 0xD8, 0xFF, 0xE0, 0x00, 0x10, 0x4A, 0x46, 0x49, 0x46 };
    var content = new byte[random.Next(1000, 5000)];
    random.NextBytes(content);

    var finalContent = new byte[fakeJpg.Length + content.Length];
    Array.Copy(fakeJpg, finalContent, fakeJpg.Length);
    Array.Copy(content, 0, finalContent, fakeJpg.Length, content.Length);

    File.WriteAllBytes(path, finalContent);
}

void GeneratePdfFile(string path, Random random)
{
    // Minimal PDF header
    var content = "%PDF-1.4\n% Fake PDF for testing\n";
    content += new string('X', random.Next(1000, 3000));
    File.WriteAllText(path, content);
}

void GenerateExcelFile(string path, Random random)
{
    // Fake Excel file
    var content = $"FAKE XLSX - Created {DateTime.Now}\n";
    content += new string('0', random.Next(800, 2500));
    File.WriteAllText(path, content);
}

void EncryptFile(string filePath, string key, string extension)
{
    var fileData = File.ReadAllBytes(filePath);
    var encryptedData = SimpleEncrypt(fileData, key);

    var encryptedPath = filePath + extension;
    File.WriteAllBytes(encryptedPath, encryptedData);

    // Delete original (ransomware behavior)
    File.Delete(filePath);

    Console.WriteLine($"[+] Encrypted: {Path.GetFileName(filePath)} -> {Path.GetFileName(encryptedPath)}");
}

void DecryptAllFiles(string folder, string key, string extension)
{
    var encryptedFiles = Directory.GetFiles(folder, $"*{extension}");

    Console.WriteLine($"[*] Found {encryptedFiles.Length} encrypted files");

    int decryptedCount = 0;
    foreach (var encryptedFile in encryptedFiles)
    {
        try
        {
            var encryptedData = File.ReadAllBytes(encryptedFile);
            var decryptedData = SimpleDecrypt(encryptedData, key);

            var originalPath = encryptedFile.Substring(0, encryptedFile.Length - extension.Length);
            File.WriteAllBytes(originalPath, decryptedData);

            // Delete encrypted file
            File.Delete(encryptedFile);

            Console.WriteLine($"[+] Decrypted: {Path.GetFileName(originalPath)}");
            decryptedCount++;
        }
        catch (Exception ex)
        {
            Console.WriteLine($"[-] Failed to decrypt {Path.GetFileName(encryptedFile)}: {ex.Message}");
        }
    }

    Console.WriteLine($"[+] Successfully decrypted {decryptedCount} files");

    // Delete ransom note
    var ransomNote = Path.Combine(folder, "DECRYPT_INSTRUCTIONS.txt");
    if (File.Exists(ransomNote))
    {
        File.Delete(ransomNote);
        Console.WriteLine("[+] Removed ransom note");
    }
}

byte[] SimpleEncrypt(byte[] data, string key)
{
    // Simple XOR encryption (weak but reversible and fast for demo)
    var keyBytes = Encoding.UTF8.GetBytes(key);
    var encrypted = new byte[data.Length];

    for (int i = 0; i < data.Length; i++)
    {
        encrypted[i] = (byte)(data[i] ^ keyBytes[i % keyBytes.Length]);
    }

    return encrypted;
}

byte[] SimpleDecrypt(byte[] data, string key)
{
    // XOR is symmetric, so decrypt is same as encrypt
    return SimpleEncrypt(data, key);
}

static class NativeMethods
{
    public const int MB_YESNO = 0x00000004;
    public const int MB_ICONWARNING = 0x00000030;
    public const int MB_SYSTEMMODAL = 0x00001000;
    public const int IDYES = 6;
    public const int IDNO = 7;

    [DllImport("user32.dll", CharSet = CharSet.Unicode)]
    public static extern int MessageBox(IntPtr hWnd, string text, string caption, int type);
}
