/*
 * MODULE: PDF Text
 * ID: pdf-text
 * DESCRIPTION: Adds custom text content to PDF documents
 * CATEGORY: PDF Actions
 * SUPPORTED_EXECUTION_TYPES: pdf-document
 *
 * PARAMETERS:
 * @TextContent|string||||placeholder=Please review the attached invoice for processing,required|Text content to add to PDF
 * @FontSize|int|14|8|48|optional|Font size for the text
 * @IsBold|bool|false|||optional|Whether text should be bold
 */

// USINGS
using System;
using QuestPDF.Fluent;
using QuestPDF.Helpers;
using QuestPDF.Infrastructure;

// CODE
Console.WriteLine($"[*] PDF Text Module");
Console.WriteLine($"[*] Text Content: {@TextContent}");
Console.WriteLine($"[*] Font Size: {@FontSize}");
Console.WriteLine($"[*] Bold: {@IsBold}");

try
{
    // Add text to the PDF page
    var textContainer = page.Content()
        .AlignCenter()
        .AlignMiddle()
        .Text(@TextContent)
        .FontSize(@FontSize)
        .FontColor(Colors.Black);

    // Apply bold styling if requested
    if (@IsBold)
    {
        textContainer.Bold();
    }

    Console.WriteLine("[+] PDF text added successfully");
}
catch (Exception ex)
{
    Console.WriteLine($"[-] Error adding PDF text: {ex.Message}");
}
