/*
 * MODULE: URL Visitor
 * ID: url-visitor
 * DESCRIPTION: Visits specified URLs using HttpClient
 * CATEGORY: Network Actions
 * SUPPORTED_EXECUTION_TYPES: native-executable,native-executable-aot
 *
 * PARAMETERS:
 * @Urls|stringlist|https://www.github.com|||placeholder=https://example.com,required|Comma-separated list of URLs to visit
 */

// USINGS
using System;
using System.Net.Http;
using System.Threading.Tasks;

// CODE
using var httpClient = new HttpClient();
var urls = new string[] { @Urls };

foreach (var url in urls)
{
    try
    {
        // Ensure URL has a protocol
        var fullUrl = url;
        if (!fullUrl.StartsWith("http://", StringComparison.OrdinalIgnoreCase) &&
            !fullUrl.StartsWith("https://", StringComparison.OrdinalIgnoreCase))
        {
            fullUrl = "https://" + fullUrl;
        }

        Console.WriteLine($"Visiting: {fullUrl}");
        var response = httpClient.GetStringAsync(fullUrl).GetAwaiter().GetResult();
        Console.WriteLine($"Response length: {response.Length} bytes");
    }
    catch (Exception ex)
    {
        Console.WriteLine($"Failed to visit {url}: {ex.Message}");
    }
}
