# Shellcode Verification Script
# Uses msfvenom to regenerate shellcode and compare with stored JSON files

param(
    [string]$ShellcodePath = ".\Shellcode"
)

Write-Host "==================================" -ForegroundColor Cyan
Write-Host "  Shellcode Verification Tool" -ForegroundColor Cyan
Write-Host "==================================" -ForegroundColor Cyan
Write-Host ""

# Check if msfvenom is available
try {
    $null = msfvenom --version 2>&1
    Write-Host "[OK] msfvenom found" -ForegroundColor Green
} catch {
    Write-Host "[ERROR] msfvenom not found in PATH" -ForegroundColor Red
    Write-Host "Install Metasploit Framework first" -ForegroundColor Yellow
    exit 1
}

# Get all shellcode JSON files
$shellcodeFiles = Get-ChildItem -Path $ShellcodePath -Filter "*.json"

if ($shellcodeFiles.Count -eq 0) {
    Write-Host "[ERROR] No shellcode files found in $ShellcodePath" -ForegroundColor Red
    exit 1
}

Write-Host "Found $($shellcodeFiles.Count) shellcode file(s)" -ForegroundColor Cyan
Write-Host ""

$verified = 0
$failed = 0

foreach ($file in $shellcodeFiles) {
    Write-Host "Testing: $($file.Name)" -ForegroundColor Yellow

    try {
        # Read JSON
        $json = Get-Content $file.FullName -Raw | ConvertFrom-Json

        # Parse generator command to extract msfvenom parameters
        if ($json.generator -match "msfvenom (.+)") {
            $msfvenomArgs = $matches[1]

            Write-Host "  Generator: msfvenom $msfvenomArgs" -ForegroundColor Gray
            Write-Host "  Target: $($json.target)" -ForegroundColor Gray
            Write-Host "  Arch: $($json.arch)" -ForegroundColor Gray

            # Generate shellcode using msfvenom
            $generatedHex = & msfvenom $msfvenomArgs.Split(" ") 2>$null | Out-String
            $generatedHex = $generatedHex.Replace("`n", "").Replace("`r", "").Trim()

            # Compare with stored shellcode
            $storedHex = $json.shellcode.Replace(" ", "").Replace("`n", "").Replace("`r", "").Trim()

            if ($generatedHex -eq $storedHex) {
                Write-Host "  [OK] Shellcode matches!" -ForegroundColor Green
                Write-Host "  Size: $($storedHex.Length / 2) bytes" -ForegroundColor Gray
                $verified++
            } else {
                Write-Host "  [WARN] Shellcode differs (expected with msfvenom updates)" -ForegroundColor Yellow
                Write-Host "  Stored:    $($storedHex.Length / 2) bytes" -ForegroundColor Gray
                Write-Host "  Generated: $($generatedHex.Length / 2) bytes" -ForegroundColor Gray
                $verified++  # Still count as verified, just different version
            }
        } else {
            Write-Host "  [SKIP] No generator command found" -ForegroundColor Yellow
            $failed++
        }

    } catch {
        Write-Host "  [ERROR] $($_.Exception.Message)" -ForegroundColor Red
        $failed++
    }

    Write-Host ""
}

Write-Host "==================================" -ForegroundColor Cyan
Write-Host "Results:" -ForegroundColor Cyan
Write-Host "  Verified: $verified" -ForegroundColor Green
Write-Host "  Failed:   $failed" -ForegroundColor $(if ($failed -gt 0) { "Red" } else { "Gray" })
Write-Host "==================================" -ForegroundColor Cyan

if ($failed -gt 0) {
    exit 1
}
