# Clean up DEVELOPER.md by removing old tutorial content
$file = "DEVELOPER.md"
$content = Get-Content $file -Raw

# Find the section to remove (from "lines.Add" to "Your recipes can now")
$startPattern = '---\s+lines\.Add\(\$"Computer Name'
$endPattern = 'Your recipes can now combine any available modules[^\n]+\n\n---'

if ($content -match "(?s)($startPattern.*?$endPattern)") {
    $toRemove = $matches[1]
    # Replace with just the separator
    $content = $content -replace [regex]::Escape($toRemove), "---`n`n"
    Set-Content $file -Value $content -NoNewline
    Write-Host "Successfully cleaned up DEVELOPER.md"
} else {
    Write-Host "Pattern not found - manual cleanup may be needed"
}
