/*
 * MODULE: Hard Disk Size Check
 * ID: hdd-size-check
 * DESCRIPTION: Exits if HDD size is below threshold (VM detection)
 * CATEGORY: Hardware Detection
 * SUPPORTED_EXECUTION_TYPES: native-executable,native-executable-aot
 *
 * PARAMETERS:
 * @MinSizeGB|int|80|10|10000|required|Minimum disk size in GB required
 */

// USINGS
using System;
using System.IO;

// CODE
var diskInfo = new DriveInfo("C");
var totalDiskGB = diskInfo.TotalSize / (1024.0 * 1024.0 * 1024.0);
Console.WriteLine($"[HDD Check] Detected {totalDiskGB:F2} GB disk space");

if (totalDiskGB < @MinSizeGB)
{
    Console.WriteLine($"[HDD Check] FAILED - Has {totalDiskGB:F2} GB disk space, required minimum: {@MinSizeGB} GB. Exiting due to insufficient disk space.");
    Environment.Exit(1);
}
else
{
    Console.WriteLine($"[HDD Check] PASSED - Has {totalDiskGB:F2} GB disk space, meets minimum requirement of {@MinSizeGB} GB.");
}
