/*
 * MODULE: PDF Image
 * ID: pdf-image
 * DESCRIPTION: Embeds images into PDF documents
 * CATEGORY: PDF Actions
 * SUPPORTED_EXECUTION_TYPES: pdf-document
 *
 * PARAMETERS:
 * @ImagePath|string||||placeholder=company-logo.png,required|Path to image file to embed
 * @Position|choice|center|top:center:bottom||required|Position of image (top, center, bottom)
 * @Width|int|200|50|800||Image width in pixels
 */

// USINGS
using System;
using System.IO;
using QuestPDF.Fluent;
using QuestPDF.Infrastructure;

// CODE
Console.WriteLine($"[*] PDF Image Module");
Console.WriteLine($"[*] Image Path: {@ImagePath}");
Console.WriteLine($"[*] Position: {@Position}");
Console.WriteLine($"[*] Width: {@Width}px");

try
{
    // Verify image file exists
    if (!File.Exists(@ImagePath))
    {
        Console.WriteLine($"[-] Image file not found: {@ImagePath}");
        throw new FileNotFoundException($"Image file not found: {@ImagePath}");
    }

    // Determine vertical alignment based on position
    var alignment = @Position.ToLower() switch
    {
        "top" => VerticalAlignment.Top,
        "bottom" => VerticalAlignment.Bottom,
        _ => VerticalAlignment.Middle
    };

    // Add image to the PDF page
    page.Content()
        .AlignVertical(alignment)
        .AlignCenter()
        .Image(@ImagePath)
        .FitWidth(@Width);

    Console.WriteLine("[+] PDF image embedded successfully");
}
catch (Exception ex)
{
    Console.WriteLine($"[-] Error embedding PDF image: {ex.Message}");
}
