/*
 * MODULE: PDF Hyperlink
 * ID: pdf-hyperlink
 * DESCRIPTION: Inserts clickable hyperlinks into PDF documents
 * CATEGORY: PDF Actions
 * SUPPORTED_EXECUTION_TYPES: pdf-document
 *
 * PARAMETERS:
 * @LinkText|string|View Document Online|placeholder=Access Secure Portal,required|Text to display for the link
 * @LinkUrl|string|https://secure-portal.company-services.com/documents||placeholder=https://portal.company.com/verify,required|URL the link points to
 * @Position|choice|center|top:center:bottom||required|Position of link (top, center, bottom)
 */

// USINGS
using System;
using QuestPDF.Fluent;
using QuestPDF.Helpers;
using QuestPDF.Infrastructure;

// CODE
Console.WriteLine($"[*] PDF Hyperlink Module");
Console.WriteLine($"[*] Link Text: {@LinkText}");
Console.WriteLine($"[*] Link URL: {@LinkUrl}");
Console.WriteLine($"[*] Position: {@Position}");

try
{
    // Determine vertical alignment based on position
    var alignment = @Position.ToLower() switch
    {
        "top" => VerticalAlignment.Top,
        "bottom" => VerticalAlignment.Bottom,
        _ => VerticalAlignment.Middle
    };

    // Add hyperlink to the PDF page
    page.Content()
        .AlignVertical(alignment)
        .AlignCenter()
        .Hyperlink(@LinkUrl)
        .Text(@LinkText)
        .FontSize(12)
        .FontColor(Colors.Blue.Medium)
        .Underline();

    Console.WriteLine("[+] PDF hyperlink added successfully");
}
catch (Exception ex)
{
    Console.WriteLine($"[-] Error adding PDF hyperlink: {ex.Message}");
}
