import unittest
from vxdb import config_dhash


class TestPublicApi(unittest.TestCase):
    def test_dhash(self):
        config = {
            "type": "emotet_spam",
            "urls": [
                {"cnc": "23.253.207.142", "port": 8080},
                {"cnc": "185.187.198.4", "port": 8080},
                {"cnc": "46.228.205.245", "port": 4143},
            ],
            "hdr_const": 355370982,
        }

        self.assertEqual(
            config_dhash(config),
            "f16fbc9c2a977daed84a5cc5e36c5bbf4bf0da044d3bf1cb367bdb05ff915c70",
        )

    def test_dhash_with_blob(self):
        blob_contents = '<mcconf><ver>1000495</ver><gtag>win242</gtag><servs><srv>198.23.209.201:443</srv>' \
                        '<srv>164.68.120.60:443</srv><srv>5.182.210.109:443</srv><srv>185.99.2.149:443</srv>' \
                        '<srv>23.95.231.187:443</srv><srv>5.182.211.44:443</srv><srv>185.62.188.83:443</srv>' \
                        '<srv>5.2.76.122:443</srv><srv>198.8.91.10:443</srv><srv>92.63.105.138:443</srv><srv>' \
                        '95.181.198.151:443</srv><srv>79.174.12.245:443</srv><srv>195.123.240.81:443</srv>' \
                        '<srv>85.143.219.230:443</srv><srv>176.119.159.204:443</srv><srv>146.185.219.31:443' \
                        '</srv><srv>51.89.73.159:443</srv><srv>195.123.221.194:443</srv><srv>64.44.133.157:443' \
                        '</srv><srv>190.214.13.2:449</srv><srv>181.140.173.186:449</srv><srv>181.129.104.139:449' \
                        '</srv><srv>181.113.28.146:449</srv><srv>181.112.157.42:449</srv><srv>170.84.78.224:449' \
                        '</srv><srv>200.21.51.38:449</srv><srv>46.174.235.36:449</srv><srv>36.89.85.103:449</srv>' \
                        '<srv>181.129.134.18:449</srv><srv>186.71.150.23:449</srv><srv>131.161.253.190:449</srv>' \
                        '<srv>200.127.121.99:449</srv><srv>114.8.133.71:449</srv><srv>119.252.165.75:449</srv><srv>' \
                        '121.100.19.18:449</srv><srv>202.29.215.114:449</srv><srv>180.180.216.177:449</srv><srv>' \
                        '171.100.142.238:449</srv><srv>186.232.91.240:449</srv><srv>181.196.207.202:449</srv>' \
                        '</servs><autorun><module name="pwgrab"/></autorun></mcconf>'
        config = {
            "version": 1000495,
            "botnet": "win242",
            "urls": [
                {"cnc": "198.23.209.201", "port": 443},
                {"cnc": "164.68.120.60", "port": 443},
                {"cnc": "5.182.210.109", "port": 443},
                {"cnc": "185.99.2.149", "port": 443},
                {"cnc": "23.95.231.187", "port": 443},
                {"cnc": "5.182.211.44", "port": 443},
                {"cnc": "185.62.188.83", "port": 443},
                {"cnc": "5.2.76.122", "port": 443},
                {"cnc": "198.8.91.10", "port": 443},
                {"cnc": "92.63.105.138", "port": 443},
                {"cnc": "95.181.198.151", "port": 443},
                {"cnc": "79.174.12.245", "port": 443},
                {"cnc": "195.123.240.81", "port": 443},
                {"cnc": "85.143.219.230", "port": 443},
                {"cnc": "176.119.159.204", "port": 443},
                {"cnc": "146.185.219.31", "port": 443},
                {"cnc": "51.89.73.159", "port": 443},
                {"cnc": "195.123.221.194", "port": 443},
                {"cnc": "64.44.133.157", "port": 443},
                {"cnc": "190.214.13.2", "port": 449},
                {"cnc": "181.140.173.186", "port": 449},
                {"cnc": "181.129.104.139", "port": 449},
                {"cnc": "181.113.28.146", "port": 449},
                {"cnc": "181.112.157.42", "port": 449},
                {"cnc": "170.84.78.224", "port": 449},
                {"cnc": "200.21.51.38", "port": 449},
                {"cnc": "46.174.235.36", "port": 449},
                {"cnc": "36.89.85.103", "port": 449},
                {"cnc": "181.129.134.18", "port": 449},
                {"cnc": "186.71.150.23", "port": 449},
                {"cnc": "131.161.253.190", "port": 449},
                {"cnc": "200.127.121.99", "port": 449},
                {"cnc": "114.8.133.71", "port": 449},
                {"cnc": "119.252.165.75", "port": 449},
                {"cnc": "121.100.19.18", "port": 449},
                {"cnc": "202.29.215.114", "port": 449},
                {"cnc": "180.180.216.177", "port": 449},
                {"cnc": "171.100.142.238", "port": 449},
                {"cnc": "186.232.91.240", "port": 449},
                {"cnc": "181.196.207.202", "port": 449}
            ],
            "public_key": {
                "t": "ecdsa_pub_p384",
                "x": "3742067904504044416825214432099211423284466927075923804425"
                     "0879934812786808711791604245018012615478338668625881758064",
                "y": "4932519521119379107882309939233205684582235529120728741944"
                     "18186840639107921534807780771666497479139475043"
            },
            "type": "trickbot",
            "raw_cfg": {
                "in-blob": {
                    "content": blob_contents
                }
            }
        }
        self.assertEqual(
            config_dhash(config),
            "bb746125514931fe0f216305ba5a1dab3da60a8527977a4df6d1db3e6d859d58"
        )
